/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.js.formatter.nodes;

import com.aptana.editor.js.formatter.nodes.FormatterJSTextNode;
import com.aptana.formatter.IFormatterDocument;
import com.aptana.formatter.nodes.NodeTypes;

public class FormatterJSPunctuationNode
extends FormatterJSTextNode {
    private NodeTypes.TypePunctuation nodeType;
    private boolean forceLineTermination;

    public FormatterJSPunctuationNode(IFormatterDocument document, NodeTypes.TypePunctuation nodeType, boolean hasCommentBefore) {
        super(document, true, hasCommentBefore);
        this.nodeType = nodeType;
    }

    public FormatterJSPunctuationNode(IFormatterDocument document, NodeTypes.TypePunctuation nodeType, boolean forceLineTermination, boolean hasCommentBefore) {
        this(document, nodeType, hasCommentBefore);
        this.forceLineTermination = forceLineTermination;
    }

    public int getSpacesCountBefore() {
        switch (this.nodeType) {
            case CASE_COLON: {
                return this.getDocument().getInt("js.formatter.spaces.before.case.colon.operator");
            }
            case COMMA: 
            case ARRAY_COMMA: {
                return this.getDocument().getInt("js.formatter.spaces.before.commas");
            }
            case SEMICOLON: {
                return this.getDocument().getInt("js.formatter.spaces.before.semicolon.operator");
            }
            case FOR_SEMICOLON: {
                return this.getDocument().getInt("js.formatter.spaces.before.for.semicolon.operator");
            }
        }
        return super.getSpacesCountBefore();
    }

    public int getSpacesCountAfter() {
        switch (this.nodeType) {
            case CASE_COLON: {
                return this.getDocument().getInt("js.formatter.spaces.after.case.colon.operator");
            }
            case COMMA: 
            case ARRAY_COMMA: {
                return this.getDocument().getInt("js.formatter.spaces.after.commas");
            }
            case SEMICOLON: {
                return this.getDocument().getInt("js.formatter.spaces.after.semicolon.operator");
            }
            case FOR_SEMICOLON: {
                return this.getDocument().getInt("js.formatter.spaces.after.for.semicolon.operator");
            }
        }
        return super.getSpacesCountBefore();
    }

    protected boolean isAddingEndNewLine() {
        return this.forceLineTermination || super.isAddingEndNewLine();
    }

    protected void setForceLineTermination(boolean force) {
        this.forceLineTermination = force;
    }
}

